/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.planning.algorithms;

import com.google.common.base.Preconditions;
import cz.insophy.inplan.plan.Activity;
import cz.insophy.inplan.plan.Bubble;
import cz.insophy.inplan.plan.WorkplaceActivity;
import java.util.Iterator;

public class BubbleJoinIterator
implements Iterator<WorkplaceActivity> {
    private final Iterator<? extends WorkplaceActivity> it;
    private WorkplaceActivity storedWa;

    public BubbleJoinIterator(Iterator<? extends WorkplaceActivity> wpIt) {
        Preconditions.checkNotNull(wpIt);
        this.it = wpIt;
    }

    @Override
    public boolean hasNext() {
        return this.it.hasNext() || this.storedWa != null;
    }

    @Override
    public WorkplaceActivity next() {
        Activity nextWa;
        if (this.storedWa != null) {
            nextWa = this.storedWa;
            this.storedWa = null;
        } else {
            WorkplaceActivity wa = this.it.next();
            Activity nextBubble = null;
            while (wa instanceof Bubble) {
                if (nextBubble == null) {
                    nextBubble = (Bubble)wa;
                } else {
                    long bubStart = Math.min(nextBubble.getStart(), wa.getStart());
                    long bubEnd = Math.max(nextBubble.getEnd(), wa.getEnd());
                    nextBubble = new Bubble(bubStart, bubEnd, wa.getWorkplace());
                }
                if (!this.it.hasNext()) break;
                wa = this.it.next();
            }
            if (nextBubble != null) {
                nextWa = nextBubble;
                this.storedWa = wa;
            } else {
                nextWa = wa;
            }
        }
        return nextWa;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

